C
C
      SUBROUTINE EIRENE_FZRTRI(X0,Z0,NNEW,XOLD,PH,NOLD)
C
C  CALCULATE THE LOCAL COORDINATES X0,Z0 IN ZONE NNEW
C
C  FROM THE CELL NUMBER NOLD,
C       THE X COORDINATE XOLD (=X+RMTOR) IN THAT CELL
C       THE TOROIDAL ANGLE PH
C
C  INPUT : XOLD,PH,NOLD, NNEW
C  OUTPUT: X0,Z0
C
C
      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_CCONA
      USE EIRMOD_CGRID

      IMPLICIT NONE

      REAL(DP), INTENT(IN) :: XOLD, PH
      REAL(DP), INTENT(OUT) :: X0, Z0
      INTEGER, INTENT(IN) :: NOLD, NNEW
      REAL(DP) :: WLOC1, WLOC2, WTH, Z1, RR, XNEW

      Z1=ZSURF(1)
      WTH=MOD(PH+PI2A-Z1,PI2A)+Z1
      WLOC1=WTH-ZZONE(NOLD)
      RR=XOLD/COS(WLOC1)
C
      WLOC2=WTH-ZZONE(NNEW)
      XNEW=RR*COS(WLOC2)
      X0=XNEW-RMTOR
      Z0=TAN(WLOC2)*XNEW
      RETURN
      END SUBROUTINE EIRENE_FZRTRI
