C
C
      SUBROUTINE EIRENE_FZRTOR(X,Z,NOLD,XNEW,PH,NNEW,LTEST,NTEST)
C
C  INPUT :
C    X     : X COORDINATE
C    Z     : Z COORDINATE
C    NOLD  : X AND Z ARE GIVEN IN LOCAL SYSTEM NOLD
C  OUTPUT:
C    PH    : TOROIDAL ANGLE (0<=PH<2PI)
C    NNEW  : TOROIDAL ZONE NUMBER (1 <= NNEW <= NTTRAM)
C    XNEW  : X COORDINATE IN LOCAL SYSTEM OF CELL NNEW
C  IF LTEST: TEST IF NNEW=NTEST, NTEST IS INPUT (EXPECTED VALUE OF NNEW)
C
C  FROM LOCAL COORDINATES X,Z IN THE TOROIDAL CELL NUMBER NOLD
C
      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_CCONA
      USE EIRMOD_CGRID
      USE EIRMOD_COMPRT

      IMPLICIT NONE

      REAL(DP), INTENT(IN) :: X, Z
      REAL(DP), INTENT(OUT) :: XNEW, PH
      INTEGER, INTENT(IN) :: NOLD, NTEST
      INTEGER, INTENT(OUT) :: NNEW
      LOGICAL, INTENT(IN) :: LTEST
      REAL(DP) :: Z1, ZOLD, XOLD, WLOC, RR
      INTEGER :: EIRENE_LEARCA
      EXTERNAL :: EIRENE_LEARCA
C
      XOLD=X+RMTOR
      ZOLD=Z
C  TOROIDAL ANGLE PH AND NEW TOROIDAL CELL NUMBER
      Z1=ZSURF(1)
      PH=MOD(ZZONE(NOLD)+ATAN2(ZOLD,XOLD)+PI2A-Z1,PI2A)+Z1
      NNEW=EIRENE_LEARCA(PH,ZSURF,1,NTTRA,1,'FZRTOR ')
      NNEW=MIN(NTTRAM,NNEW)
C  RADIAL COORDINATE
      RR=SQRT(XOLD*XOLD+ZOLD*ZOLD)
C  LOCAL COORDINATES IN CELL NNEW
      WLOC=PH-ZZONE(NNEW)
      XNEW=RR*COS(WLOC)
      IF (LTEST) THEN
        IF (NTEST.NE.NNEW) THEN
C  POSITION ON (NEAR) TOROIDAL SURFACE?
          IF (ABS(PH-ZSURF(NTEST)).GT.EPS12.AND.
     .        ABS(PH-ZSURF(NTEST+1)).GT.EPS12) THEN
            WRITE (iunout,*)
     .       'ERROR IN FZRTOR: WRONG TOROIDAL CELL INDEX'
            WRITE (iunout,*) 'XOLD,ZOLD,XNEW,PH  ',XOLD,ZOLD,XNEW,PH
            WRITE (iunout,*) 'NNEW,NTST ',NNEW,NTEST
            WRITE (iunout,*) 'ABS(PH-ZSURF(NTST)),ABS(PH-ZSURF(NTST+1))'
            WRITE (iunout,*)
     .             ABS(PH-ZSURF(NTEST)),ABS(PH-ZSURF(NTEST+1))
            WEIGHT=0.
            LGPART=.FALSE.
          ENDIF
        ENDIF
      ENDIF
      RETURN
      END SUBROUTINE EIRENE_FZRTOR
