!pb  22.03.07:  LEVGEO=6 --> LEVGEO=10
!cdr 22.06.16:  error exit in learc1 replaced by return (levgeo 1 and levgeo 2)
!cdr dec.  19:  IRET=1 rather than return *
C
      SUBROUTINE EIRENE_CLLTST(IRET)

      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_CCONA
      USE EIRMOD_CLOGAU
      USE EIRMOD_CUPD
      USE EIRMOD_CGRID
      USE EIRMOD_COMPRT
      USE EIRMOD_LEARC1, ONLY: EIRENE_LEARC1

      IMPLICIT NONE

      INTEGER, INTENT(OUT) :: IRET
      REAL(DP) :: PHITEST, ZTESTO, PHIT, X0T, Z0T, TTT, ZTESTU,
     .          WINK
      INTEGER :: NTEST2, EIRENE_LEARC2, IPOLGT, EIRENE_LEARCT, NTEST0,
     .           EIRENE_LEARCA, EIRENE_LEAUSR, NTEST1
      EXTERNAL :: EIRENE_LEARCA, EIRENE_LEARC2, EIRENE_LEARCT,
     .            EIRENE_LEAUSR,
     .            EIRENE_MASJ1, EIRENE_MASJ3, EIRENE_MASR3,
     .            EIRENE_EXIT_OWN

C
      IRET=0

      IF (NACELL.GT.0) RETURN
C
C  TEST FOR RADIAL CELL INDICES NRCELL, IPOLG
C
      select case (LEVGEO)
      case (:4)        !  slab, circ, polyg, triang.
C
        NTEST0=EIRENE_LEARC1(X0,Y0,Z0,IPOLGT,1,NR1STM,.FALSE.,.FALSE.,
     .                NPANU,'CLLTST      ')
C
      case (5)         !  tetrahedra
C
        NTEST0=EIRENE_LEARCT(X0,Y0,Z0)
C
      case (10)        !  externally supplied geometry
C
        NTEST0=EIRENE_LEAUSR(X0,Y0,Z0)
C
      end select
C
      IF(NTEST0.NE.NRCELL.AND..NOT.NLSRFX) THEN
        WRITE (iunout,*) 'WRONG CELL NUMBER IN RADIAL DIRECTION'
        CALL EIRENE_MASJ3
     .        ('NRCELL,NTEST0,NPANU      ',NRCELL,NTEST0,NPANU)
        IRET=1
        RETURN
      ENDIF
C
C  TEST FOR POLOIDAL CELL INDEX
C
      IF (NLPOL) THEN
        select case (LEVGEO)
        case (1)
          NTEST1=EIRENE_LEARCA(Y0,PSURF,1,NP2ND,1,'CLLTST    ')
        case (2)
          IF (NLCRC) THEN
            WINK=MOD(ATAN2(Y0,X0)+PI2A-PSURF(1),PI2A)+PSURF(1)
            NTEST1=EIRENE_LEARCA(WINK,PSURF,1,NP2ND,1,'CLLTST    ')
          ELSE
            NTEST1=EIRENE_LEARC2(X0,Y0,NRCELL,NPANU,'CLLTST  ')
          ENDIF
        case (3)
          NTEST1=IPOLGT
        case default
          WRITE (iunout,*) 'ERROR EXIT IN CLLTST, NLPOL ',NPCELL
          CALL EIRENE_EXIT_OWN(1)
        end select

        IF (NTEST1.NE.NPCELL.AND..NOT.NLSRFY) THEN
          WRITE (iunout,*) 'WRONG CELL NUMBER IN POLOIDAL DIRECTION'
          CALL EIRENE_MASJ3
     .           ('NPCELL,NTEST1,NPANU     ',NPCELL,NTEST1,NPANU)
          IRET=1
          RETURN
        ENDIF
      ENDIF
C
C  TEST FOR 3RD CELL INDEX
C
      IF (NLTOR) THEN
C  IN CYLINDER APPROXIMATION
        IF (NLTRZ) THEN
          NTEST2=EIRENE_LEARCA(Z0,ZSURF,1,NTTRA,1,'CLLTST      ')
C  IN TOROIDAL APPROXIMATION
        ELSEIF (NLTRA) THEN
          PHIT=PHI
          IF (PHIT.LT.ZSURF(1)) PHIT=PHIT+PI2A
          IF (PHIT.GT.ZSURF(NTTRA)) PHIT=PHIT-PI2A
          PHITEST=ATAN2(Z0,(RMTOR+X0))+ZZONE(NTCELL)
          IF (ABS(PHIT-PHITEST).GT.EPS10) THEN
            WRITE (iunout,*) 'PHI,PHITEST  ',
     .                        PHIT,PHITEST,PHIT-PHITEST,NTCELL
            CALL EIRENE_MASJ1 ('NPANU   ',NPANU)
          ENDIF
          NTEST2=EIRENE_LEARCA(PHIT,ZSURF,1,NTTRA,1,'CLLTST      ')
C
        ENDIF
        IF (NTEST2.NE.NTCELL.AND..NOT.NLSRFZ) THEN
          WRITE (iunout,*) 'WRONG CELL NUMBER IN TOROIDAL DIRECTION'
          CALL EIRENE_MASJ3
     .            ('NTCELL,NTEST2,NPANU     ',NTCELL,NTEST2,NPANU)
          IF (NLTRA) THEN
            ZTESTO=ZFULL*NTCELL
            ZTESTU=ZFULL*(NTCELL-1)
            CALL EIRENE_MASR3
     .             ('ZTESTU,PHI,ZTESTO=      ',ZTESTU,PHI,ZTESTO)
            IRET=1
            RETURN
          ENDIF
        ENDIF
C
      ELSEIF (.NOT.NLTOR.AND.NLTRA) THEN
        PHIT=PHI
        IF (PHIT.LT.ZSURF(1)) PHIT=PHIT+PI2A
        IF (PHIT.GT.ZSURF(NTTRA)) PHIT=PHIT-PI2A
        NTEST2=EIRENE_LEARCA(PHIT,ZSURF,1,NTTRA,1,'CLLTST      ')
        PHITEST=ATAN2(Z0,(RMTOR+X0))+ZZONE(NTEST2)
        IF (ABS(PHIT-PHITEST).GT.EPS10) THEN
          WRITE (iunout,*) 'PHI,PHITEST  ',
     .                      PHIT,PHITEST,PHIT-PHITEST,NTEST2
          CALL EIRENE_MASJ1 ('NPANU   ',NPANU)
        ENDIF
C
        X0T=X0+RMTOR
        Z0T=Z0
        TTT=Z0T/(X0T*TANAL)
        IF (ABS(TTT).GT.1.+EPS10) THEN
          WRITE (iunout,*) 'WRONG COORDINATES IN TOROIDAL DIRECTION'
          CALL EIRENE_MASJ1 ('NPANU   ',NPANU)
          CALL EIRENE_MASR3 ('X0,Z0,TTT                ',X0,Z0,TTT)
          IRET=1
          RETURN
        ENDIF
C
        IF (NTEST2.NE.IPERID.AND..NOT.NLSRFZ) THEN
          WRITE (iunout,*) 'WRONG CELL NUMBER IN TOROIDAL DIRECTION'
          CALL EIRENE_MASJ3
     .              ('IPERID,NTEST2,NPANU     ',IPERID,NTEST2,NPANU)
          IRET=1
          RETURN
        ENDIF
C
      ELSEIF (.NOT.NLTOR.AND.NLTRZ) THEN
C  3RD COORDINATE IS COMPLETELY IGNORABLE
C  NOTHING TO BE DONE
        RETURN

      ENDIF
C
      RETURN
      END SUBROUTINE EIRENE_CLLTST
