C> \brief Evaluate EIRENE recommendations for a next run of the same
C>        model
C>
C> 1. find NRECOM(istra): recommended number of test particles for next MC cycle.
C> 2. find RATIO(istra) : ratio between used and recommended no. of particles.
C>     (the procedure should approach RATIO approx 1.0, after cycling)
C> 3. write NRECOM, RATIO and XMCT on stream 14.
C>
C> At subroutine rrec:
C> - read NRECOM, RATIO, XMCT from stream 14.
      SUBROUTINE EIRENE_WRREC
C
cdr:  Aug 18:  xmct is not used here at all. Instead CPUFAC is just somehow
cdr            inferred by other considerations.
C
      USE EIRMOD_PRECISION, ONLY: DP
      USE EIRMOD_PARMMOD, ONLY: IFOFF, NSTRA
      USE EIRMOD_CAI, ONLY: NRECOM, RATIO, XMCT
      USE EIRMOD_CCONA, ONLY: EPS60
      USE EIRMOD_CTRCEI, ONLY: TRCFLE, TRCREC
      USE EIRMOD_COMSOU, ONLY: NPTS, NSTRAI
      USE EIRMOD_COMPRT, ONLY: IUNOUT
      USE EIRMOD_COUTAU, ONLY: FLXFAC, FLUXT, WTOTA, WTOTI, WTOTM,
     >                         WTOTP, XMCP

      IMPLICIT NONE

      REAL(DP) :: WSUM, FTOT, XNSUM
      INTEGER :: NREQ, ISTRA
      REAL(DP) :: WTOTT(NSTRA),WMEAN(NSTRA),WREC(NSTRA),XNEXP(NSTRA),
     .            CPUFAC(NSTRA)
      EXTERNAL :: EIRENE_PAGE, EIRENE_LEER

      OPEN (UNIT=14+ifoff,ACCESS='SEQUENTIAL',FORM='UNFORMATTED')
      REWIND 14+ifoff
C
C  FIRSTLY: STRATIFIED SOURCE SAMPLING
C
      IF (NSTRAI.EQ.1) THEN
        RATIO(1)=1.
        GOTO 350
      ENDIF
C
      WSUM=0.
      NREQ=0
      FTOT=0.
      DO 100 ISTRA=1,NSTRAI
        IF (XMCP(ISTRA).LE.0.D0) GOTO 100
        WTOTT(ISTRA)=-WTOTP(0,ISTRA)+WTOTA(0,ISTRA)+
     .                WTOTM(0,ISTRA)+WTOTI(0,ISTRA)
        WTOTT(ISTRA)=WTOTT(ISTRA)/(FLXFAC(ISTRA)+EPS60)
        WMEAN(ISTRA)=WTOTT(ISTRA)/(XMCP(ISTRA)+EPS60)
        WSUM=WSUM+WTOTT(ISTRA)
        NREQ=NREQ+NPTS(ISTRA)
        FTOT=FTOT+FLUXT(ISTRA)
  100 CONTINUE
C
C  PROPORTIONAL ALLOCATION: RECOMMENDED REL. WEIGHT PER STRATUM: WREC
C                           EXPECTED REL. NO. OF PARTICLES NEEDED: XNEXP
C                           RECOMMENDED NO. OF PARTICLES: NRECOM
C  NOT THE NO. OF PARTICLES BUT THE SUM OF BIRTH WEIGHTS PER STRATUM
C  IS ALLOCATED PROPORTIONAL TO THE RELATIVE STRATUM POPULATION
C
C
      XNSUM=0.
      DO 200 ISTRA=1,NSTRAI
        IF (XMCP(ISTRA).LE.0.D0) GOTO 200
cdr recommended allocation: propto FLUX(ISTRA)
        WREC(ISTRA)=FLUXT(ISTRA)/(FTOT+EPS60)
        XNEXP(ISTRA)=WREC(ISTRA)/(WMEAN(ISTRA)+EPS60)

C  ACCOUNT FOR DIFFERENT COMPUTING SPEED AT DIFFERENT STRATA
C  ASSUME THEREFORE THAT ALLOCATED CPU TIME WAS PROPORTIONAL NPTS(ISTRA)

cdr  this is not the case any more due to parameter alloc(istra)
cdr  instead of cpufac one should use XMCT(istra) information

        CPUFAC(ISTRA)=XMCP(ISTRA)/(DBLE(NPTS(ISTRA))+EPS60)
        XNEXP(ISTRA)=XNEXP(ISTRA)/(CPUFAC(ISTRA)+EPS60)
        XNSUM=XNSUM+XNEXP(ISTRA)
  200 CONTINUE
      DO 300 ISTRA=1,NSTRAI
        RATIO(ISTRA)=0.
        IF (XMCP(ISTRA).LE.0.D0) GOTO 300
C  SCALE XNEXP TO CONSERVE TOTAL NUMBER OF REQUESTED TRACKS
        XNEXP(ISTRA)=XNEXP(ISTRA)*DBLE(NREQ)/(XNSUM+EPS60)
C  CONVERT XNEXP TO AN INTEGER
        NRECOM(ISTRA)=INT(REAL(XNEXP(ISTRA),DP))
        IF (XNEXP(ISTRA)-DBLE(NRECOM(ISTRA)).GT.0.5)
     .      NRECOM(ISTRA)=NRECOM(ISTRA)+1
        RATIO(ISTRA)=WREC(ISTRA)/(WTOTT(ISTRA)/(WSUM+EPS60)+EPS60)
  300 CONTINUE
C
  350 CONTINUE
      IF (TRCFLE) WRITE (iunout,*) 'WRITE 14: RATIO, NRECOM, XMCT'
      WRITE (14+ifoff) RATIO,NRECOM
      WRITE (14+ifoff) XMCT
      CLOSE (14+ifoff)
C
      IF (.NOT.TRCREC.OR.NSTRAI.EQ.1) GOTO 1000
      CALL EIRENE_PAGE
      WRITE (iunout,*)
     .  '=================================================='
      WRITE (iunout,*)
     .  '= RECOMMENDED INPUT MODIFICATIONS FOR STRATIFIED ='
      WRITE (iunout,*)
     .  '= SOURCE SAMPLING                                ='
      WRITE (iunout,*)
     .  '=================================================='
      CALL EIRENE_LEER(3)
      WRITE (iunout,*) 'NPTS OLD = OLD INPUT VALUE FOR NPTS '
      WRITE (iunout,*) 'NPTS REC = EIRENE RECOMMENDATION FOR NEXT RUN '
      WRITE (iunout,*)
     .  'RATIO    = RECOM. REL.WEIGHT / ACTUAL REL. WEIGHT'
      WRITE (iunout,*) 'VALUES OF RATIO CLOSE TO ONE MEAN '
      WRITE (iunout,*) '"ALMOST PROPORTIONAL ALLOCATION OF WEIGHTS"'
      CALL EIRENE_LEER(2)
      WRITE (iunout,*) 'STRAT. NO, NPTS OLD, NPTS REC, RATIO '
      DO 400 ISTRA=1,NSTRAI
        WRITE (iunout,'(1X,I2,8X,I6,4X,I6,5X,1P,E12.4)')
     .                ISTRA,NPTS(ISTRA),NRECOM(ISTRA),RATIO(ISTRA)
  400 CONTINUE
      CALL EIRENE_LEER(2)
 1000 CONTINUE
C
C  STRATIFIED SOURCE SAMPLING ASSESSMENT FINISHED
C
C  SECONDLY: WEIGHT WINDOWS
C
C  TO BE WRITTEN
C
      RETURN
      END SUBROUTINE EIRENE_WRREC
C
      SUBROUTINE EIRENE_RREC
      USE EIRMOD_PARMMOD, ONLY: IFOFF
      USE EIRMOD_CAI, ONLY: NRECOM, RATIO, XMCT
      USE EIRMOD_CTRCEI, ONLY: TRCFLE
      USE EIRMOD_COMPRT, ONLY: IUNOUT
      USE EIRMOD_CINIT, ONLY: FORT
      IMPLICIT NONE
      EXTERNAL EIRENE_LEER
C
      OPEN (UNIT=14+ifoff,ACCESS='SEQUENTIAL',FORM='UNFORMATTED')
      REWIND 14+ifoff
      IF (TRCFLE) WRITE (iunout,*) 'READ 14: RATIO, NRECOM, XMCT'
      READ (14+ifoff,END=914) RATIO,NRECOM
      READ (14+ifoff) XMCT
      CLOSE(14+ifoff)
C
      RETURN
C
CXPB  SAFETY ADDED FOR CASE WHEN FORT.14 IS ABSENT
  914 CONTINUE
      CLOSE (UNIT=14+ifoff)
      WRITE (IUNOUT,*) 'FILE '//FORT//'14 WAS FOUND EMPTY'
      WRITE (IUNOUT,*) 'DID NOT READ RATIO, NRECOM, AND XMCT ARRAYS'
      CALL EIRENE_LEER(1)
      RETURN
      END SUBROUTINE EIRENE_RREC
