C  28.6.05:  Zexp2=1. for ARGST, in transparent cells with infinite mfp.
c  10.4.06:  use ipht rather than iphot, in order not to spoil ISPZ for
c            chctrc output.
C
      SUBROUTINE EIRENE_SIGRAD(IFIRST,JJJ,ZDS,PEN,PSIG,TIMAX,ARGST)
C
C  INPUT:
C          IFIRST: FLAG FOR INITIALISATION
C          NCELL:  INDEX IN TALLY ARRAYS FOR CURRENT ZONE
C          JJJ:    INDEX OF SEGMENT ALONG CHORD
C          ZDS:    LENGTH OF SEGMENT NO. JJJ
C          PEN:    ENERGY (EV) AT WHICH CX FLUXES ARE TO BE EVALUATED
C  OUTPUT: CONTRIB. FROM CELL NCELL AND CHORD SEGMENT JJJ TO:
C          THE RAD. FLUX PSIG(IATM),IATM=0,NATMI OF ENERGY PEN (EV)
C          THE INTEGRAND ARGST SUCH THAT INTEGR.(ARGST*DL) = PSIG
C
      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_COMUSR
      USE EIRMOD_CESTIM
      USE EIRMOD_CADGEO
      USE EIRMOD_CCONA
      USE EIRMOD_CLOGAU
      USE EIRMOD_CUPD
      USE EIRMOD_COMSIG
      USE EIRMOD_CGRID
      USE EIRMOD_CZT1
      USE EIRMOD_CTRCEI
      USE EIRMOD_CGEOM
      USE EIRMOD_COMPRT
      USE EIRMOD_CLGIN
      USE EIRMOD_COMXS
      USE EIRMOD_CSPEI
      USE EIRMOD_PHOTON

      IMPLICIT NONE

      INTEGER, INTENT(IN) :: IFIRST, JJJ
      REAL(DP), INTENT(IN) :: ZDS, PEN
      REAL(DP), INTENT(IN OUT) :: PSIG(0:), TIMAX
      REAL(DP), INTENT(IN OUT) :: ARGST(0:,:)
      REAL(DP), ALLOCATABLE, SAVE :: ZARG2(:), ZARG3(:)
      REAL(DP) :: ZLAMB(0:NPHOT), EM_RATE(0:NPHOT),
     .            CFLAG(7,MSTOR0)
      REAL(DP) :: ZNI,
     .          ZEXP2, ATTENU, ZEXP3, SIGADD, ARGU,
     .          ZMAX, VXS, VYS, VZS, EIRENE_FPATHPH,
     .          FAC, RES
      EXTERNAL :: EIRENE_FPATHPH
      INTEGER :: NCELC, ICELL, IIPL, KK, ICOUNT, IPHT, ISAVE
      LOGICAL :: LARGST
c
c
      DATA ZMAX/40._DP/

      LARGST = SIZE(ARGST,2) >= NSBOX
      TIMAX=0.0

      IF (IFIRST.EQ.0) THEN
        ALLOCATE (ZARG2(0:NPHOT))
        ALLOCATE (ZARG3(0:NPHOT))
        DO 100 IPHT=0,NPHOTI
          ZARG2(IPHT)=0.
          ZARG3(IPHT)=0.
          PSIG(IPHT)=0.
          IF (LARGST) THEN
            DO 101 ICELL=1,NSBOX
              ARGST(IPHT,ICELL)=0.
  101       CONTINUE
          END IF
  100   CONTINUE
      ELSEIF (IFIRST.EQ.1) THEN
C
C
        NCELC=NCLTAL(NCELL)

C
C  RADIATION EMISSION FREQUENCY (1/SEC)
C  MONOENERGETIC BEAM, ENERGY PEN (EV), SPEED UNIT VECTOR:
C  -(VELX,VELY,VELZ) AND SPECIES IPHT=1,NPHOTI
C
C
C  ZNI=PROBABLILITY FOR EMISSION WITH E=PEN:
C
        E0=PEN
        EM_RATE=0._DP
        ZLAMB=1.E10_DP
        DO 300 ICOUNT=1,NCTSIG
C  kk: reaction card for emission of photons (i.e., with processtyp =6)
          KK   = INTADD(1,ICOUNT)
          IIPL = INTADD(2,ICOUNT)
          IPHT= INTADD(3,ICOUNT)
          CALL EIRENE_PH_GETCOEFF(KK,IPHT,0,NCELL,IIPL,FAC,RES)
          ZNI=FAC
C  EMISSION RATE IN PHOTONS/S/CM**3/EV
          EM_RATE(IPHT)=EM_RATE(IPHT)+RECADD(ICOUNT,NCELL)*ZNI
C  MEAN FREE PATH LENGTH FOR ATTENUATION FACTOR
C  MONOENERGETIC PHOTON BEAM, VELOCITY VEL=CLIGHT (CM/SEC), SPECIES IPHT
C  WITH SPEED UNIT VECTOR (-VELX,-VELY,-VELZ)
          VEL=CLIGHT
          VXS=VELX
          VYS=VELY
          VZS=VELZ
          VELX=-VELX
          VELY=-VELY
          VELZ=-VELZ
          E0=PEN
C  FPATHPH EXPECTS SPECIES INDEX IPHOT IN COMPRT.F
          ISAVE=IPHOT
          IPHOT=IPHT
          ZLAMB(IPHT)=EIRENE_FPATHPH(NCELL,CFLAG,1,1)
          IPHOT=ISAVE
          VELX=VXS
          VELY=VYS
          VELZ=VZS
  300   CONTINUE
C
C  ATTENUATION FACTOR:
C  FOR ALL PHOTONS WITH SPECIES INDEX IPHT
        DO 400 IPHT=1,NPHOTI
          ATTENU=1._DP
          ZARG3(IPHT)=ZARG3(IPHT)+ZARG2(IPHT)
C  IS THERE A FINITE MFP FOR THIS PHOTON?
          IF (ZLAMB(IPHT).LT.1.E10_DP) THEN
            ZARG2(IPHT)=ZDS/ZLAMB(IPHT)
            ZEXP2=0._DP
            IF (ZARG2(IPHT).LT.ZMAX) ZEXP2=EXP(-ZARG2(IPHT))
            ZEXP3=0.0
            IF (ZARG3(IPHT).LT.ZMAX) ZEXP3=EXP(-ZARG3(IPHT))
            ATTENU=ZLAMB(IPHT)*ZEXP3*(1._DP-ZEXP2)
          ELSE
C  NO ABSORPTION IN THIS CELL, ZLAMB= INFINITY.
            ZARG2(IPHT)=0._DP
            ZEXP2=1.0       ! ZEXP2=EXP(-ZARG2(IPHT))
            ZEXP3=0.0
            IF (ZARG3(IPHT).LT.ZMAX) ZEXP3=EXP(-ZARG3(IPHT))
            ATTENU=ZDS*ZEXP3
          ENDIF
C
C  SOURCE-TERM FOR PHOTONS IPHT
C
C  1.) WEGEN STREUUNG VON PHOTONEN DER SPECIES IPHT
C  2.) DIREKT  VON PRIMAERER QUELLE (Z.B.RECADD: SPONT. EMISSION)
C  3.) DIREKT  VON SEKUNDAERER QUELLE (Z.B. DURCH WANDREKOMBINATION
C                                           HIERHER GESTREUT)
C
          SIGADD=0.
C  CONTRIBUTION 1: TO BE WRITTEN
C         SIGADD= .............
C  CONTRIBUTION 2: TO BE WRITTEN
          SIGADD=EM_RATE(IPHT)
C  CONTRIBUTION 3: TO BE WRITTEN
C         SIGADD= .............
          ARGU=SIGADD
          PSIG(IPHT)=PSIG(IPHT)+ARGU*ATTENU
          IF (LARGST) ARGST(IPHT,JJJ)=ARGU*ZEXP3*SQRT(ZEXP2)/4./PIA
  400   CONTINUE
C
      ELSEIF (IFIRST.EQ.2) THEN
        DEALLOCATE (ZARG2)
        DEALLOCATE (ZARG3)
      ENDIF
      RETURN
      END SUBROUTINE EIRENE_SIGRAD
