CDR nov 17:  unification of fpath:  check logatm ??
C
      SUBROUTINE EIRENE_SIGCX(IFIRST,JJJ,ZDS,PEN,PSIG,TIMAX,ARGST)
C
C  INPUT:
C          IFIRST: FLAG FOR INITIALISATION
C          NCELL:  INDEX IN TALLY ARRAYS FOR CURRENT ZONE
C          JJJ:    INDEX OF SEGMENT ALONG CHORD
C          ZDS:    LENGTH OF SEGMENT NO. JJJ
C          PEN:    ENERGY (EV) AT WHICH CX FLUXES ARE TO BE EVALUATED
C  OUTPUT: CONTRIB. FROM CELL NCELL AND CHORD SEGMENT JJJ TO:
C          THE CX FLUX PSIG(IATM),IATM=0,NATMI OF ENERGY PEN (EV)
C          THE MAX. ION TEMP. TIMAX ALONG LINE OF SIGHT
C          THE INTEGRAND ARGST SUCH THAT INTEGR.(ARGST*DL) = PSIG
C
      USE EIRMOD_PRECISION
      USE EIRMOD_PARMMOD
      USE EIRMOD_COMUSR
      USE EIRMOD_CESTIM
      USE EIRMOD_CADGEO
      USE EIRMOD_CCONA
      USE EIRMOD_CLOGAU
      USE EIRMOD_CUPD
      USE EIRMOD_COMSIG
      USE EIRMOD_CGRID
      USE EIRMOD_CZT1
      USE EIRMOD_CTRCEI
      USE EIRMOD_CGEOM
      USE EIRMOD_COMPRT
      USE EIRMOD_CLGIN
      USE EIRMOD_COMXS
      USE EIRMOD_CSPEI
      USE EIRMOD_SWITCH_PARTINFO, ONLY: EIRENE_SWITCH_PARTINFO

      IMPLICIT NONE

      INTEGER, INTENT(IN) :: IFIRST, JJJ
      REAL(DP), INTENT(IN) :: ZDS, PEN
      REAL(DP), INTENT(IN OUT) :: TIMAX
      REAL(DP), INTENT(IN OUT) :: PSIG(0:)
      REAL(DP), INTENT(IN OUT) :: ARGST(0:,:)
      REAL(DP), ALLOCATABLE, SAVE :: ZARG2(:), ZARG3(:)
      REAL(DP) :: ZLAMB(0:NATM),
     .          SIGTTT(0:NATM,NPLS), CFLAG(7,MSTOR0), ZNI(NRCX)
      REAL(DP) :: ELAB, CXS, CXRATE, EIRENE_CROSS, PVELQ0, VREL,
     .          VRELQ, ZEXP2, ATTENU, ZEXP3, SIGADD, ARGU, ZEXP1,
     .          ZMAX, VXS, VYS, VZS, ZTII, ZARG1, ZTI32, EIRENE_FPATH,
     .          ZTI, TTARG, EDR
      INTEGER :: IREAC, IAT, NCELC, ICELL, IRCX, IACX, IPLSTI,
     .          JATM, JPLS
      LOGICAL :: LARGST
      EXTERNAL :: EIRENE_CROSS, EIRENE_FPATH
C
      DATA ZMAX/40._DP/

      LARGST = SIZE(ARGST,2) >= NSBOX

      IF (IFIRST.EQ.0) THEN
        ALLOCATE (ZARG2(0:NATM))
        ALLOCATE (ZARG3(0:NATM))
        TIMAX=0.
        DO 100 JATM=0,NATMI
          PSIG(JATM)=0.
          ZARG2(JATM)=0.
          ZARG3(JATM)=0.
          IF (LARGST) THEN
            DO 101 ICELL=1,NSBOX
              ARGST(JATM,ICELL)=0.
  101       CONTINUE
          END IF
  100   CONTINUE
      ELSEIF (IFIRST.EQ.1) THEN
C
C  MEAN FREE PATH LENGTH FOR ATTENUATION FACTOR
C  IONS IPLS WITH (SHIFTED, VXIN,VYIN,VZIN) MAXWELLIAN
C  AT KT=TIIN(IPLS,NCELL),
C  ALL SPECIES IN PLASMA
C  ELECTRONS WITH  MAXWELLIAN AT KT=TEIN(NCELL),
C  MONOENERGETIC NEUTRAL BEAM, VELOCITY VEL (CM/SEC), SPECIES IATM
C  WITH SPEED UNIT VECTOR (-VELX,-VELY,-VELZ)
C
        NCELC=NCLTAL(NCELL)

        DO 200 JATM=1,NATMI
c  at this point: LOGATM(JATM,ISTRA) must be true.  Checked ?
          VEL=SQRT(PEN/RMASSA(JATM))*CVELAA
          VXS=VELX
          VYS=VELY
          VZS=VELZ
          VELX=-VELX
          VELY=-VELY
          VELZ=-VELZ
!  SET PARTICLE TYPE TO ATOM AND PREPARE POINTER FOR UNIFIED SUBROUTINE FPATH
          ITYP = 1
          CALL EIRENE_SWITCH_PARTINFO
          ZLAMB(JATM)=EIRENE_FPATH(NCELL,CFLAG,1,1)
          VELX=VXS
          VELY=VYS
          VELZ=VZS
  200   CONTINUE
C
C  CX-COLLISION FREQUENCY (1/SEC)
C  MONOENERGETIC ION BEAM, ENERGY PEN (EV), SPEED UNIT VECTOR:
C  -(VELX,VELY,VELZ) AND SPECIES IPLS=1,NPLSI
C  NEUTRALS WITH MAXWELLIAN KT=2/3*EDENA/PDENA, SPECIES IATM=1,NATMI
C  ASSUME: POST-COLLISION NEUTRAL = PRE-COLLISION ION: PEN, -(VELX,VELY,VELZ)
C
        DO JATM=0,NATMI
          DO JPLS=1,NPLSI
            SIGTTT(JATM,JPLS)=0.
          END DO
        END DO
        ZNI = 0._DP
C
        DO 311 JATM=1,NATMI
          IF (LGACX(JATM,0,0).EQ.0) GOTO 311
          IF (LGVAC(NCELL,0).OR.PDENA(JATM,NCELC).LE.0.) GOTO 311
C  NEUTRAL DRIFT VELOCITIES (XDR,YDR,ZDR) NOT YET ACCOUNTED FOR.
C  INCIDENT ION BEAM (PEN) MUST BE CONVERTED INTO A FRAME IN WHICH
C  NEUTRAL DRIFT=0. NEXT LINE MUST CONTAIN NEUTRAL DRIFT ENERGY.
          EDR=0.
          TTARG=2./3.*(EDENA(JATM,NCELC)-EDR)/PDENA(JATM,NCELC)
          ZTI=TTARG*8./PIA*CVEL2A*CVEL2A
          DO 310 IACX=1,NACXI(JATM)
            IRCX=LGACX(JATM,IACX,0)
            JPLS=LGACX(JATM,IACX,1)
C           IAT_IN = JATM
C           IPL_IN = JPLS
C           IAT_OUT= N1STX(IRCX,2)
C           IPL_OUT= N2NDX(IRCX,2)
C
C  LOCAL ION TEMPERATURE
C
            IPLSTI = MPLSTI(JPLS)
            ZTII=TIIN(IPLSTI,NCELL)
            TIMAX=MAX(TIMAX,ZTII)
C
C  ZNI=PROBABLILITY FOR EMISSION OF ATOMS IAT_OUT WITH E=PEN:
C          FROM MAXW. ENERGY DISTR. OF IONS IPL_IN GOING INTO CX
C  ZNI: 1/EV
            ZTI32=1.0/(ZTII*SQRT(ZTII))
            ZARG1=PEN/ZTII
            ZEXP1=0.
            IF(ZARG1.LE.ZMAX) ZEXP1=EXP(-ZARG1)
            ZNI(IRCX)=(ZEXP1*ZTI32)*SQRT(PEN)
C  CX process data for ircx assume: beam jatm, ions: ipls
            VEL=SQRT(PEN/RMASSA(JATM))*CVELAA
            PVELQ0=VEL*VEL
C
            VRELQ=ZTI/RMASSP(JPLS)+PVELQ0
            VREL=SQRT(VRELQ)
C  STRICTLY: A BEAM (ION, IPL_IN) MAXWELLIAN (NEUTRAL, IAT_OUT)
C  RATE COEFFICIENT SHOULD BE COMPUTED
C  this should be obtained from <sigma v>(IRCX) with proper
c  choice of Ti_scaled and E_scaled
C  USE APPROXIMATION: <SIGMA V> APPROX SIGMA(V_EFF)*V_EFF
C  IS CX CROSS-SECTION AVAILABLE ?
            IREAC=MODCOL(3,1,IRCX)
            IF (IREAC.EQ.-1.OR.IREAC.GT.0) THEN
              ELAB=LOG(VRELQ)+DEFCX(IRCX)

              CXS=EIRENE_CROSS(ELAB,IREAC,IRCX,FACRCX(IRCX,1),'SIGCX ')
              CXRATE=CXS*VREL
C
              SIGTTT(JATM,JPLS)=CXRATE*PDENA(JATM,NCELC)
            ELSE
              WRITE (iunout,*) 'CROSS-SECTION NOT AVAILABLE IN SIGCX  '
            ENDIF
  310     CONTINUE
C
  311   CONTINUE
C
C  UP TO THIS POINT, IATM IS THE SPECIES INDEX OF THE ATOM GOING INTO
C  CX WITH BULK ION IPLS, AND SIGTTT(IATM,IPLS) IS THE CORRESPONDING RATE.
C  FOR THE SPECTRUM, NOW, THE ATOM SPECIES AFTER CX MATTERS
C  (E.G., IF : H + D+ --> D + H+
C  THEN, UP TO NOW, IATM WAS H. FROM NOW ON IT MUST STAND FOR D.)
C
C  ATTENUATION FACTOR:
C  FOR ALL CX ATOMS WITH SPECIES INDEX JATM, TRAVELLING IN JPLS
        DO 400 JATM=1,NATMI
          ZARG3(JATM)=ZARG3(JATM)+ZARG2(JATM)
          ZARG2(JATM)=ZDS/ZLAMB(JATM)
          ZEXP2=0.0
          ZEXP3=0.0
          IF(ZARG2(JATM).LT.ZMAX) ZEXP2=EXP(-ZARG2(JATM))
          IF(ZARG3(JATM).LT.ZMAX) ZEXP3=EXP(-ZARG3(JATM))
          ATTENU=ZLAMB(JATM)*ZEXP3*(1-ZEXP2)
C
C  SOURCE-TERM FOR ATOMS JATM
C
C  1.) CX OF IONS JPLS WITH ATOMS IAT_IN, RESULTING IN JATM=IAT_OUT
C  2.) DIRECT FROM PRIMARY SOURCE (E.G. RECADD: RECOMBINATION)
C  3.) DIRECT FROM NON-CX  SECONDARY SOURCE (E.G. WALL REFLECTION INTO PEN, LINE)
C
          SIGADD=0.
C  CONTRIBUTION 1:
          DO IRCX = 1, NRCX
            IF ( N1STX(IRCX,2) /= JATM ) CYCLE
            IF (ANY(LGACX(:,:,0)==IRCX)) THEN
C  IAT IS THAT ATOM SPECIES, WHICH RESULTS IN JATM AFTER CX WITH JPLS
C  FIND PRE-COLLISION ATOM INDEX IAT:
              DO IAT=1,NATMI
                DO IACX=1,NACXI(IAT)
                  IF (LGACX(IAT,IACX,0) == IRCX) THEN
                    JPLS = LGACX(IAT,IACX,1)
                    SIGADD=SIGTTT(IAT,JPLS)*DIIN(JPLS,NCELL)+SIGADD
                  END IF
                END DO
              END DO
            END IF
            ARGU=ZNI(IRCX)*SIGADD
            PSIG(JATM)=PSIG(JATM)+ARGU*ATTENU
            IF (LARGST) ARGST(JATM,JJJ)=ARGU*ZEXP3*SQRT(ZEXP2)/11.137
          END DO
C  CONTRIBUTION 2: TO BE WRITTEN
C         SIGADD=RECADD(JATM,NCELL)  ......
C  CONTRIBUTION 3: TO BE WRITTEN
C         SIGADD= .............
  400   CONTINUE
C
      ELSEIF (IFIRST.EQ.2) THEN
        DEALLOCATE (ZARG2)
        DEALLOCATE (ZARG3)
      ENDIF
      RETURN
      END SUBROUTINE EIRENE_SIGCX
