C
C
      SUBROUTINE EIRENE_NCELLN
     .  (NCELL,NR,NP,NT,NA,NB,NR1,NP2,NT3,NBL,LR,LP,LT)
C  FIND STANDARD 3D MESH CELL NUMBERS NR,NP,NT FROM 1D ARRAY CELL NUMBER NCELL
C
C  INPUT:
C     LR : NLRAD  LOGICAL: TRUE IF THERE IS A GRID IN X (RADIAL) DIRECTION
C                 NR1ST > 1 THEN
C     LP : NLPOL  SAME, FOR Y (POLOIDAL) GRID
C     LT : NLTOR  SAME, FOR Z (TOROIDAL) GRID
C     NR1: NR1ST  (INPUT BLOCK 2, NR1ST-1 IS THE NUMBER OF X-CELLS)
C     NP2: NP2ND  (INPUT BLOCK 2, NP2ND-1 IS THE NUMBER OF Y-CELLS)
C     NT3: NT3RD  (INPUT BLOCK 2, NT3RD-1 IS THE NUMBER OF Z-CELLS)
C     NBL: NBMLT  DEFAULT: =1  (GT 1 ONLY IF THERE ARE MORE THAN BLOCKS)
C  OUTPUT:
C     NR : X (RADIAL) CELL NUMBER.
C                     IF NR=NR1ST: THIS CELL CONTAINS RADIAL AVERAGE
C     NP : Y (POLOIDAL) CELL NUMBER.
C                     IF NP=NP2ND: THIS CELL CONTAINS POLOIDAL AVERAGE
C     NT : Z (TOROIDAL) CELL NUMBER.
C                     IF NT=NT3RD: THIS CELL CONTAINS TOROIDAL AVERAGE
C
C
      IMPLICIT NONE
      INTEGER, INTENT(IN) :: NCELL, NR1, NP2, NT3, NBL
      INTEGER, INTENT(OUT) :: NR, NP, NT, NA, NB
      LOGICAL, INTENT(IN) :: LR,LP,LT
      INTEGER :: NCELL0, NBLCKA, NP2T3, NSTRD, NR1P2, N12, NCELL1,
     .           NCELL2, NCELL3, N23

      NSTRD=NR1*NP2*NT3
      IF (NCELL.GT.NSTRD*NBL) THEN
C  ADDITIONAL CELL OUTSIDE THE STANDARD GRID. RETURN: NA:=ADDITIONAL CELL NO.
        NA=NCELL-NSTRD*NBL
        NB=NBL+1
        NR=0
        NP=1
        NT=1
        RETURN
      ELSEIF (NCELL.EQ.0) THEN
        NA=0
        NB=1
        NR=0
        NP=1
        NT=1
        RETURN
      ENDIF
C
C  AT THIS POINT: 1 <= NCELL <= NSURF, HENCE: NA=0
C
      NR1P2=0
      IF (LP.OR.LT) NR1P2=NR1
      NP2T3=0
      IF (LT) NP2T3=NP2
C
      NCELL0=NCELL
      NA=0
      NB=(NCELL0-1)/NSTRD+1
      NBLCKA=NSTRD*(NB-1)+NA
C
      NCELL1=NCELL0-NBLCKA
      IF (LT) THEN
        N23=(NCELL1-1)/NR1P2+1
        NT=(N23-1)/NP2T3+1
      ELSE
        NT=1
      ENDIF
C
      NCELL2=NCELL1-(NT-1)*NP2T3*NR1P2
      IF (LP) THEN
        N12=NCELL2
        NP=(N12-1)/NR1P2+1
      ELSE
        NP=1
      ENDIF
C
      NCELL3=NCELL2-(NP-1)*NR1P2
      NR=NCELL3
      RETURN
      END SUBROUTINE EIRENE_NCELLN
