C
C
      SUBROUTINE EIRENE_ARPOLY(X,Y,N,M1,MI,ME,AREA2,XCOM,YCOM)
C
C  THIS SUBROUTINE EVALUATES SOME QUANTITIES OF M POLYGONS OF LENGTH N
C  GIVEN BY THE X COORDINATES X(J,I)
C  AND      THE Y COORDINATES Y(J,I), J=MI,ME, I=1,N
C  M1 IS THE LEADING DIMENSION IN THE ARRAYS X AND Y  AS SPECIFIED IN
C     THE CALLING PROGRAM.
C  OUTPUT:
C  AREA2(J,I) = AREA OF POLYGON SEGMENT J,I,J+1,I+1
C  XCOM(J,I)  = X COORDINATE OF CENTER OF MASS OF SEGMENT J,I,J+1,I+1
C  YCOM(J,I)  = Y COORDINATE OF CENTER OF MASS OF SEGMENT J,I,J+1,I+1
C
      USE EIRMOD_PRECISION
      IMPLICIT NONE
      INTEGER, INTENT(IN) :: N, M1, MI, ME
      REAL(DP), INTENT(IN) :: X(M1,*), Y(M1,*)
      REAL(DP), INTENT(OUT) :: AREA2(M1,*), XCOM(*), YCOM(*)
      REAL(DP) :: A1, B1, C1, A2, B2, C2, RHO1, RHO2, AREAD1, AREAD2,
     .          XCD1, YCD1, XCD2, YCD2
      INTEGER :: IP1, J, JP1, I, NM1, MEM1, IN

      MEM1=ME-1
      NM1=N-1
      DO 10 J=MI,MEM1
        JP1=J+1
        DO 20 I=1,NM1
          IP1=I+1
          IN=J+(I-1)*ME
C  AREA OF CELLS
          A1=SQRT((X(J,I)-X(J,IP1))**2+(Y(J,I)-Y(J,IP1))**2)
          B1=SQRT((X(JP1,IP1)-X(J,IP1))**2+(Y(JP1,IP1)-Y(J,IP1))**2)
          C1=SQRT((X(J,I)-X(JP1,IP1))**2+(Y(J,I)-Y(JP1,IP1))**2)
          RHO1=0.5*(A1+B1+C1)
          A2=SQRT((X(J,I)-X(JP1,I))**2+(Y(J,I)-Y(JP1,I))**2)
          B2=SQRT((X(JP1,IP1)-X(JP1,I))**2+(Y(JP1,IP1)-Y(JP1,I))**2)
          C2=C1
          RHO2=0.5*(A2+B2+C2)
          AREAD1=SQRT(MAX(0._DP,RHO1*(RHO1-A1)*(RHO1-B1)*(RHO1-C1)))
          AREAD2=SQRT(MAX(0._DP,RHO2*(RHO2-A2)*(RHO2-B2)*(RHO2-C2)))
          AREA2(J,I)=AREAD1+AREAD2
C  CENTER OF MASS
          XCD1=(X(J,I)+X(JP1,IP1)+X(J,IP1))/3.
          YCD1=(Y(J,I)+Y(JP1,IP1)+Y(J,IP1))/3.
          XCD2=(X(J,I)+X(JP1,I)+X(JP1,IP1))/3.
          YCD2=(Y(J,I)+Y(JP1,I)+Y(JP1,IP1))/3.
          XCOM(IN)=(XCD1*AREAD1 + XCD2*AREAD2) / (AREA2(J,I)+1.E-60_DP)
          YCOM(IN)=(YCD1*AREAD1 + YCD2*AREAD2) / (AREA2(J,I)+1.E-60_DP)
   20   CONTINUE
   10 CONTINUE
      RETURN
      END SUBROUTINE EIRENE_ARPOLY
