---
title: EIRENE public licence
lang: en
---

:::info
EIRENE IFN-1, Forschungszentrum Jülich GmbH (FZJ)
**EPL (EIRENE Public Licence)**
Version: 1.2.0
Copyright Forschungszentrum Jülich GmbH
:::

**Table of contents**
- [Preamble](#preamble)
- [1. Scope](#1-scope)
- [2. Definitions](#2-definitions)
- [3. Rights and Obligations](#3-rights-and-obligations)
- [4. Copyright](#4-copyright)
- [5. Warranty](#5-warranty)
- [6. Liability](#6-liability)
- [7. Publications](#7-publications)
- [8. Acceptance of the Licence](#8-acceptance-of-the-licence)

# Preamble

EIRENE is a Monte-Carlo Solver for transport of neutrals in fusion-relevant plasma devices. This Code is often used as a part of self-consistent packages with fluid codes and referred to as a Neutral Gas Module (NGM) or EIRENE-NGM.

EIRENE is an essential part of the SOLPS-ITER package (B2.5-EIRENE) as well as other similar packages employed in the international development effort of nuclear fusion as an energy source. The Licensor welcomes a representative of ITER and EUROfusion to obtain the rights of Associated Developers (AD) in any of the communities unless some limitations on that are set by other ADs in respective Developer Codes of Conduct (DCoC). This is meant to encourage an as close as possible development of EIRENE, SOLPS-ITER and other packages.

The Code is a work in progress which is continuously improved by numerous contributors. The Licence and the Developer Code of Conduct (DCoC) of each of the AD communities may be changed accordingly. The licence is meant to evolve together with the code and is expected to be contained in the same repository as the source.

# 1. Scope

EPL applies to Works (see "Definitions") made available under the terms of this License. The Work may be used only in the form permitted by this Licence.

The Licence has two layers of effect. The first layer with access to the Code of the last consolidated Source Code version of EIRENE is the BASIC level. Such users and developers should be referred to as basic developers (BD). Basic developers may use EIRENE within the scope of the Licence and get reading access to the repository accordingly.

Within the second layer a user can access the Source Code of EIRENE in its current state as an ASSOCIATED DEVELOPER (AD). The user is still bound by the basic rules of the Licence as in the BASIC level, but also has access to development, an active community and support. Additionally, Associated Developers may convey their Work within the community including acknowledgment for said work. They may also provide services with the Code and/or provide access to the Executable Code for commercial purposes. However, they may exert the rights of the second layer only within their AD community. If a user wishes to publish a paper which refers to the use of EIRENE you may designate yourself as an AD.

The ADs will act according to the Developer Code of Conduct (DCoC). If one chooses to no longer be a part of the AD community or however else loses this status, s/hereverts to the BASIC level concerning the part of the work, obtained after this point.

One may only apply for a Licence if you are employed by or otherwise affiliated with a publicly funded non-profit research organisation.

# 2. Definitions

The following definitions apply to this License:

"Licence": this Licence.

"Original Work": the work or software distributed or made available by the Licensor under this License, as Source Code and, if applicable, as Executable Code.

"Derivative Works": the work or software that is modified based on the original Work or its adaptations.

"Work": the original work and/or its Adaptations.

"Source Code": that form of the Work that is intended to be perceived by humans and which is most suitable for human understanding and modification.

"Executable Code": the compiled form of the work, to be executed by a computer as a program.

"Licensor" means the Forschungszentrum Jülich GmbH.

"Licensee" ("You", "User"): any natural or legal person, who uses the Work under the Licence as an BD or AD.

"Community": the community is composed of the Forschungszentrum Jülich GmbH and the Associated Developers, including (if applicable) their employees as well as
visiting scientists or external contractors, which are tasked with programming assignments concerning EIRENE.

"Developer Code of Conduct" (DCoC): written document, available for all ADs and persons interested to enter the community, which regulates the main policies about the code versioning, related publications, programming style, general decision making, entering/leaving the community, etc.

"Basic developer" (BD): Level of limited access to the Work, still allowing you to use and develop the code as an open source one based on any of the milestone versions under certain additional conditions (see below).

"Associated Developer" (AD): As an AD you may contribute to the work and convey it within the community as a derivative. You have access to the development repository, share your Code within the community and send your contribution to the Licensor for Code Review. If your contribution is successfully reviewed it becomes part of the Original Work in the way of a perpetual, irrevocable, worldwide, non-exclusive, transferable, no-charge, royalty-free, unrestricted licence to the Licensor.

"Contribution": Any Source Code, object code, data file, patch, tool, sample, graphic, specification, manual, documentation, or any other material, posted or submitted by You to the Licensor.

"Convey" or "making available" means any form of transfer, distribution, dissemination, transmission, or otherwise making available online or offline making available of reproductions of the Work.

"Non-Commercial": there is no paid distribution, or other commercial exploitation of the Work.

"Milestone Version" (MsV): any AD community will be able to release the milestone versions, which are meant to be made available to all Basic Developers (1st layer of the license) unlike the internal development inside the particular AD community, to which access can be kept restricted. Any MsV version should have a clear history of the previous MsVs on which it is based . It is expected that the MsVs will be released relatively seldom marking significant stages of the development. It is however, strongly recommended to have an MsV, before any fork is to be started. Thus, a MsV, is a snapshot for the package like any other version, however it is expected to be tested and documented in the best possible way. The latter is left to the judgement of the AD community releasing the MsV.

"Forks":  forks are versions of the Code, which are significantly incompatible with each other, despite being based on one of the EIRENE MsVs. Basically, it is obviously in the common interest to avoid any forking, however it is not always fully possible. It is foreseen that merging of the forks will happen from time to time and will lead to new MsV releases (e.g. joint between 2 or more AD communities). Obviously each merging action will demand additional effort, however, the long-term forks are known to lose with time all the advantages of the joint development, thus their scientific value. Still, the licence leaves the decision on starting a fork to any developer including a BASIC Developer or an AD community - at their own responsibility for the consequences including any additional effort needed to keep it compatible with new developments.


# 3. Rights and Obligations

At the BASIC level the Licensor grants you a non-transferable, not-sublicensable, non-exclusive and temporary right to use and modify the Source Code for scientific, non-commercial, non-military purposes exclusively. Any Derivative Work of your creation is still bound by the Licence granted to You. Any publications created by using the Work needs a reference to the Licensor.

As an AD the Licensor grants you the same rights and obligations as for the BASIC level, but within the Community you have additional possibilities. You have access to the Source Code of EIRENE in its current state and may convey your Derivative Work within the Community freely. If you choose to convey your Work within the Community, you must deliver a machine-readable version of the Source Code or provide a location where it can be accessed by the Community easily and free of charge. Also you may provide services with the Code and/or provide access to the Executable Code for commercial purposes.

As an AD you have access to support by the Licensor regarding implementation and troubleshooting as regulated by the DCoC. You may also use the designation "ASSOCIATED DEVELOPER" or AD with mandatory naming of the exect AD community you belong to (AD is not a general status) whenever you publish a scientific work using EIRENE. You are further vested with rights and duties in form of the DCoC and agree to follow it by accepting this Licence.

If you want to contribute to EIRENE, you must be an AD and convey your Derivative Work to the Licensor. By doing so, you automatically grant the Licensor a perpetual, irrevocable, worldwide, non-exclusive, transferable, no-charge, royalty-free, unrestricted licence of your Derivative Work. If the review is successful, the Work then will be integrated into EIRENE and will become a part of the Original Work at the Licensor's discretion.

Outside of the Community the conveyance of the Source Code is prohibited. At the BASIC level you may only access the last consolidated version via the BASIC-repository. The Licensee must take all necessary security precautions to ensure that, if services are made available to third parties outside the community, no access to the Source Code is made possible by these third parties.

If you want to become an AD you may apply to the contact person (CP) responsible for the community. Any AD community is expected to govern itself based on this license with some minimal information provided to the Licensor, which should include the CP (and way of communication including a valid e-mail address), the name of the community, and the MsV(s) the Fork(s) are based on.

An AD can be a member of several AD communities. If you choose to leave the Community, you will fall back to the BASIC level regarding that part of the work you have already obtained and must delete all Code that is not covered by the BASIC level of access. In the event of a termination of the License agreement, e.g. through the Licensee leaving the Community, the Licensee must ensure that any Code, that is not covered by the BASIC level of access, is no longer used by him/her, his/her employees, his/her representatives as well as cooperation partners and that it is no longer available for use via the Licensee. Detailed procedure of new AD acceptation or expulsion will be formulated in the DCoC (which can be different for each AD community, but it is recommended to keep the rules as similar as possible to encourage effective cooperation).

You may also create your own AD community for distinct and separate pieces of software (Forks) of EIRENE at the Licensors discretion. Such a community is bound by the same rules as an AD with the exception, that You do not have to send your Derivative Work for code review, but still grant a corresponding licence to the Licensor for each contribution. You must choose a name for your own AD community discernibly different from the FZ Jülich Associated Developers community EIRENE-NGM-DEVELOPERS" and any other AD communities formed prior to yours.

# 4. Copyright

The Licensor warrants, that s/he is legitimated to grant this Licence.

The AD warrants, that s/he is legitimated to licence the Work he conveys in the scope of Section 3 of this License.

# 5. Warranty

The Work is a work in progress, which is continuously being improved by numerous Contributors. It is not a finished work and may therefore contain defects or "bugs" inherent to this type of development. For the above reason, the Work is provided under the Licence on an "as is" basis and without warranties of any kind concerning the Work, including without limitation, merchantability, fitness for a particular purpose, absence of defects or errors, accuracy, non-infringement of intellectual property rights other than copyright as stated in section 4 of this Licence.

# 6. Liability

Except in cases of willful misconduct or physical damage directly caused to natural persons, the Licensor will in no event be liable for any direct or indirect, material or moral, damages of any kind, arising out of the Licence or of the use of the Work, including, without limitation, damages for loss of goodwill, work stoppage, computer failure or malfunction, loss of data or any commercial damage, even if the Licensor has been advised of the possibility of such damage. However, the Licensor will be liable under statutory product liability laws as far such laws apply to the Work.

# 7. Publications

If you publish a paper using the Work you must put the folloing sentence into the acknoledgement including the reference:

“The results are obtained with the help of the EIRENE package (see [www.eirene.de](http://www.eirene.de)) including the related code, data and tools [x].”

[x] Reiter D., Baelmans M. and Börner P. 2005 The EIRENE and B2-EIRENE codes Fusion Sci. Technol. 47 172–86

For an AD we recommend  to add a explicit note on that, however it should madatory specify the exect AD community name.

# 8. Acceptance of the Licence

The provisions of this Licence can be accepted by clicking on an icon "I agree" placed under the bottom of a window displaying the text of this Licence or by affirming consent in any other similar way, in accordance with the rules of applicable law. Clicking on that icon indicates your clear and irrevocable acceptance of this Licence and all its terms and conditions. In case of a change in the licence you accept the new version automatically when using the version of the Work it is attached to. The changed licence is from that moment on in effect for the former version of the Work as well.

The procedure requires preliminary registration with the full name and affiliation of the person ensuring that further open source development of the code is done only by the members and in the interest of publicly funded research. In case of a registration with false information a Licence is not granted.
